<?php
namespace enums;

class WidgetChoice
{
	const RANDOM_COCKTAIL = 'random';
	const MADE_WITH = 'madewith';
	const TOP = 'top';
	const SPECIFIC = 'specific';

	public static $choices = [
		self::RANDOM_COCKTAIL => [
			'title' => 'Random cocktail',
			'words' => 'Will show a random cocktail each time the widget is loaded',
			'image' => 'img/random.avif',
		],
		self::MADE_WITH => [
			'title' => 'Made with',
			'words' => 'Will show a random cocktail that is made with a certain ingredient that you choose',
			'image' => 'img/madewith.avif',
		],
		self::TOP => [
			'title' => 'Top cocktail',
			'words' => 'Will show one of our top cocktails from the site, randomly chosen each time the widget is loaded',
			'image' => 'img/top.avif',
		],
		self::SPECIFIC => [
			'title' => 'A specific cocktail',
			'words' => 'Choose a specific cocktail to show in the widget',
			'image' => 'img/specific.avif',
		],
	];
}
