<div class="flex flex-col max-w-2xl m-auto">

	<div x-show="chosenWidget == 'specific'" x-data="{
		query: '',
		data: {},
		initialData: {},
		init() {
			fetch('<?php e_gpu(); ?>data/cocktails.json?v=2')
				.then(response => response.json())
				.then(jsonData => {
					this.data = jsonData;
					this.initialData = Object.entries(this.data);
					this.initialData = Object.fromEntries(this.initialData.slice(0, 10)); // Display 10 items on load
				})
				.catch(error => {
					console.error('Error fetching JSON data:', error);
				});
		},
		get limitedFilteredData() {
			if (this.query) {
				return Object.fromEntries(
					Object.entries(this.filteredData).slice(0, 10)
				);
			}
			return this.initialData;
		},
		getRandomEntries(data, count) {
			const entries = Object.entries(data);
			const shuffled = entries.sort(() => 0.5 - Math.random());
			return Object.fromEntries(shuffled.slice(0, count));
		},
		get filteredData() {
			if (!this.query) {
				return this.data;
			}
			return Object.fromEntries(
				Object.entries(this.data).filter(([key, value]) =>
					key.toLowerCase().includes(this.query.toLowerCase())
				)
			);
		}
	}">
		<div class="mb-8 bg-gray-200 rounded-lg p-4">
			<h4 class="text-lg font-semibold mb-4 mt-2">Cocktail</h4>

			<p class="text-sm">Search for and choose a cocktail to show.</p>

			<div class="mt-2 max-w-lg m-auto">
				<input type="text" x-model="query" placeholder="Start searching for a cocktail name" class="w-full mb-2">

				<p>And then click on your desired cocktail</p>
				<div id="results" class="flex flex-col gap-y-1 mt-2">
					<template x-for="(value, key) in limitedFilteredData" :key="key">
						<div class="px-2 py-1 bg-gray-50 rounded-md text-sm text-gray-900 flex items-center justify-between gap-x-2">
							<div x-text="key" class="grow cursor-pointer hover:opacity-50 text-left" x-on:click="cocktailChoiceName = key; cocktailChoiceId = value"></div>
							<a :href="'https://makemeacocktail.com/cocktail/' + value + '/' + stringToSlug(key)" target="_blank" class="inline-flex items-center gap-x-2 text-xs text-blue-600">
								view
								<div class="w-3">
									<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true" data-slot="icon">
										<path stroke-linecap="round" stroke-linejoin="round" d="M13.5 6H5.25A2.25 2.25 0 0 0 3 8.25v10.5A2.25 2.25 0 0 0 5.25 21h10.5A2.25 2.25 0 0 0 18 18.75V10.5m-10.5 6L21 3m0 0h-5.25M21 3v5.25"/>
									</svg>
								</div>

							</a>
						</div>
					</template>
				</div>
			</div>

			<p class="font-semibold text-sm mb-0 mt-4">The widget will always show the cocktail:</p>

			<div class="mt-2 font-bold text-lg mb-0">
				<div x-show="cocktailChoiceName != ''" x-html="cocktailChoiceName">
				</div>
				<div x-show="cocktailChoiceName == ''">
					Random <div class="font-light text-sm text-gray-600">please choose a cocktail</div>
				</div>
			</div>
		</div>
	</div>


	<div x-show="chosenWidget == 'madewith'"  x-data="{
		query: '',
		data: {},
		initialData: {},
		init() {
			fetch('<?php e_gpu(); ?>data/ingredients.json?v=2')
				.then(response => response.json())
				.then(jsonData => {
					this.data = jsonData;
					this.initialData = this.getRandomEntries(this.data, 20); // Display 10 random items on load
				})
				.catch(error => {
					console.error('Error fetching JSON data:', error);
				});
		},
		get limitedFilteredData() {
			if (this.query) {
				return Object.fromEntries(
					Object.entries(this.filteredData).slice(0, 20)
				);
			}
			return this.initialData;
		},
		getRandomEntries(data, count) {
			const entries = Object.entries(data);
			const shuffled = entries.sort(() => 0.5 - Math.random());
			return Object.fromEntries(shuffled.slice(0, count));
		},
		get filteredData() {
			if (!this.query) {
				return this.data;
			}
			return Object.fromEntries(
				Object.entries(this.data).filter(([key, value]) =>
					key.toLowerCase().includes(this.query.toLowerCase())
				)
			);
		}
	}">
		<div class="mb-8 bg-gray-200 rounded-lg p-4">
			<h4 class="text-lg font-semibold mb-4 mt-0">Ingredient</h4>

			<p class="text-sm">What ingredient do you want the random cocktail to contain?</p>


			<div class="mt-2 max-w-lg m-auto">

				<input type="text" x-model="query" placeholder="Start searching for an ingredient name" class="w-full mb-2">

				<p>And then click on your ingredient choice</p>
				<div id="results" class="flex flex-col gap-y-1 mt-2">
					<template x-for="(value, key) in limitedFilteredData" :key="key">
						<div class="px-2 py-1 bg-gray-50 rounded-md text-sm text-gray-900 cursor-pointer hover:opacity-50"
							 x-text="key"
							 x-on:click="ingredientChoiceName = key; ingredientChoiceId = value">
						</div>
					</template>
				</div>
			</div>

			<p class="font-semibold text-sm mb-0 mt-4">Will show a cocktail made with:</p>
			<div class="mt-2 font-bold text-lg mb-0">
				<div x-show="ingredientChoiceName != ''" x-html="ingredientChoiceName">
				</div>
				<div x-show="ingredientChoiceName == ''">
					Random <div class="font-light text-sm text-gray-600">please choose an ingredient</div>
				</div>
			</div>
		</div>
	</div>

	<div class=" bg-gray-200 rounded-lg p-4">
		<h4 class="text-lg font-semibold mb-4 mt-2  text-lg">Style attributes</h4>

		<p class="my-4">Leave the below as defaults if you wish, or choose some styling to suit your current site design or your personal preferences. If you're unsure, leave them as they are, we have chosen sensible defaults to use.</p>

		<div class="flex flex-col gap-y-2">
			<div class="flex justify-between gap-x-2">
				<div class="w-1/2">

					<div class="">
						<label for="width" class="block text-gray-500 font-semibold text-sm mb-2">Width</label>
						<input
							class="placeholder:text-slate-400 dark:placeholder:text-gray-200 text-sm w-full rounded-lg border px-2 py-2  focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 bg-white border-gray-100"
							type="text"
							name="width"
							placeholder="Width"
							x-model="width"
						/>
					</div>

				</div>
				<div class="flex flex-col w-1/2">
					<label for="widthUnit" class="text-gray-500 font-semibold text-sm mb-2">Unit</label>
					<select name="widthUnit" id="widthUnit"
							class="border border-gray-100 rounded-lg w-full py-1.5 pl-4 bg-white"
							x-model="widthUnit"
					>
						<option value="px">px</option>
						<option value="perc">%</option>
					</select>
				</div>
			</div>
		</div>

		<div class="flex justify-between gap-x-2 mt-3">
			<div class="flex flex-col w-1/2">
				<label for="backgroundChoice" class="text-gray-500 font-semibold text-sm mb-2">Background</label>
				<select name="backgroundChoice" id="backgroundChoice"
						class="border border-gray-100 rounded-lg w-full py-1.5 pl-4 bg-white"
						x-model="backgroundChoice"
				>
					<option value="transparent">Transparent</option>
					<option value="specify">Specify</option>
				</select>
			</div>

			<div class="w-1/2">

				<div class="">
					<label for="background" class="block text-gray-500 font-semibold text-sm mb-2">Background hex</label>
					<input
						class="placeholder:text-slate-400 dark:placeholder:text-gray-200 text-sm w-full rounded-lg border px-2 py-2  focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 bg-white border-gray-100"
						type="text"
						name="background"
						x-model="background"
						placeholder="Background hex"
					/>
				</div>

				<p class="text-xs mt-1 text-left">Just the hex value without the #</p>
			</div>
		</div>

		<h4 class="mt-8 text-lg font-semibold mb-4">Light or dark mode</h4>
		<div>
			<x-forms.label for="lightMode" class="text-gray-500 font-semibold text-sm mb-0">Choose a mode</x-forms.label>
			<select name="darklightmode" id="darklightmode"
					class="border border-gray-100 rounded-lg w-full py-1.5 pl-4 bg-white"
					x-model="darklightmode"
			>
				<option value="light">Light mode - dark text</option>
				<option value="dark">Dark mode - light text</option>
			</select>
		</div>



		<h4 class="text-lg font-semibold mb-2 mt-8">Border</h4>

		<div class="flex flex-col gap-y-2">

			<div class="w-full">
				<div class="flex justify-center">
					<div class="checkbox-holder flex gap-x-2 text-sm items-center">
						<input type="checkbox" name="showBorder" id="showBorder" x-model="showBorder"
							   class="border border-gray-300 rounded-md accent-amber-500 dark:accent-amber-400"
						/>
						<label for="showBorder" class="w-full">Use a border</label>
					</div>
				</div>
			</div>

			<div class="flex justify-center gap-x-2 min-w-[10rem]">
				<div class="flex flex-col">
					<label for="borderRadius" class="text-gray-500 font-semibold text-sm mb-0">Border radius / curve</label>
					<select name="borderRadius" id="borderRadius"
							class="border border-gray-100 rounded-lg w-full py-1.5 pl-4 bg-white"
							x-model="borderRadius"
					>
						<option value="sq">Square</option>
						<option value="sm">Small</option>
						<option value="md">Medium</option>
						<option value="lg">Large</option>
						<option value="xl">X-large</option>
					</select>
				</div>
			</div>
		</div>
	</div>


	<div class=" bg-gray-200 rounded-lg p-4 mt-4">
		<h4 class="text-lg font-semibold mb-4 mt-0">Elements</h4>

		<div class="flex flex-col gap-y-2">
			<div class="flex justify-center">
				<div class="checkbox-holder flex gap-x-2 text-sm items-center w-[200px] justify-start gap-x-2 text-left">
					<input type="checkbox" name="showImage" id="showImage" x-model="showImage"
						   class="border border-gray-300 rounded-md accent-amber-500 dark:accent-amber-400"
					/>
					<label for="showImage" class="w-full">Show the cocktail image</label>
				</div>
			</div>
			<div class="flex justify-center">
				<div class="checkbox-holder flex gap-x-2 text-sm items-center w-[200px] justify-start gap-x-2 text-left">
					<input type="checkbox" name="showMethod" id="showMethod" x-model="showMethod"
						   class="border border-gray-300 rounded-md accent-amber-500 dark:accent-amber-400"
					/>
					<label for="showMethod" class="w-full">Show the method</label>
				</div>
			</div>
			<div class="flex justify-center">
				<div class="checkbox-holder flex gap-x-2 text-sm items-center w-[200px] justify-start gap-x-2 text-left">
					<input type="checkbox" name="showIngredients" id="showIngredients" x-model="showIngredients"
						   class="border border-gray-300 rounded-md accent-amber-500 dark:accent-amber-400"
					/>
					<label for="showIngredients" class="w-full">Show the ingredients</label>
				</div>
			</div>
			<div class="flex justify-center">
				<div class="checkbox-holder flex gap-x-2 text-sm items-center w-[200px] justify-start gap-x-2 text-left">
					<input type="checkbox" name="showButton" id="showButton" x-model="showButton"
						   class="border border-gray-300 rounded-md accent-amber-500 dark:accent-amber-400"
					/>
					<label for="showButton" class="w-full">Show the button</label>
				</div>
			</div>
		</div>

		<div class="flex flex-col items-center gap-x-2 justify-center text-xs text-gray-500 text-center mt-6">
			<div>
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-exclamation-circle" viewBox="0 0 16 16">
					<path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
					<path d="M7.002 11a1 1 0 1 1 2 0 1 1 0 0 1-2 0zM7.1 4.995a.905.905 0 1 1 1.8 0l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 4.995z"/>
				</svg>
			</div>
			<div>'Powered by makemeacocktail.com' will be shown on the final widget. Premium makemeacocktail members - please contact us if you wish to remove this.</div>
		</div>
	</div>

</div>
