<h2 class="mb-4 !text-3xl mt-4">Your shortcode:</h2>

<div class="border border-gray-600 rounded-md p-4 text-sm">
	<div class="break-all font-semibold rounded-md bg-gray-300 p-4" style="font-family: courier">
		[makemeacocktail id="<span x-text="key"></span>"]
	</div>

	<input type="hidden" name="shortcode" id="shortcode" x-model="getShortcode()">

	<div
		class="mt-4 text-center m-auto hover:opacity-50 cursor-pointer"
		x-on:click="copy()"
		x-data="{
			shared: false,
			copy() {
				var text_<?php time() ?> = document.getElementById('shortcode').value;
				window.copyTextToClipboard(text_<?php time() ?>);
				this.shared = true;
			}
		}">

		<p class="mb-0">Click here to copy to clipboard</p>
		<div class="!w-5 !h-5 !min-w-5 m-auto" x-show="!shared">
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true" data-slot="icon">
				<path stroke-linecap="round" stroke-linejoin="round" d="M15.75 17.25v3.375c0 .621-.504 1.125-1.125 1.125h-9.75a1.125 1.125 0 0 1-1.125-1.125V7.875c0-.621.504-1.125 1.125-1.125H6.75a9.06 9.06 0 0 1 1.5.124m7.5 10.376h3.375c.621 0 1.125-.504 1.125-1.125V11.25c0-4.46-3.243-8.161-7.5-8.876a9.06 9.06 0 0 0-1.5-.124H9.375c-.621 0-1.125.504-1.125 1.125v3.5m7.5 10.375H9.375a1.125 1.125 0 0 1-1.125-1.125v-9.25m12 6.625v-1.875a3.375 3.375 0 0 0-3.375-3.375h-1.5a1.125 1.125 0 0 1-1.125-1.125v-1.5a3.375 3.375 0 0 0-3.375-3.375H9.75"/>
			</svg>
		</div>


		<div x-show="shared" class="text-green-500 dark:text-ice-200 text-xs inline-flex items-center" x-cloak="">
			<div class="!w-5 !h-5 !min-w-5 text-green-500">
				<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true" data-slot="icon">
					<path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75 11.25 15 15 9.75M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"/>
				</svg>
			</div>
		</div>
	</div>
</div>


<p class="text-sm !mt-6">Copy the code above and place it anywhere on your site where you want the widget to be displayed.</p>
<p class="text-sm mt-2 mb-0">You can choose <span class="font-semibold">'shortcode'</span> from the block editor and copy and paste the shortcode above to show the cocktail on the desired page or post.</p>


<h4 class="text-lg font-semibold mb-1 mt-12 border-t-2 border-gray-200 pt-8">The widget will look similar to this</h4>
<div x-show="uniqueString">
	<div id="mmac_widget"></div>
	<div id="mmac_widget_script"></div>
</div>
