<?php
require_once plugin_dir_path(__FILE__) . '../enums/WidgetChoice.php';
use enums\WidgetChoice;

$widgetChoices = WidgetChoice::$choices;

foreach($widgetChoices as $widgetValue => $widgetData) {
	?>
	<div x-on:click="chooseWidget('<?php echo esc_js($widgetValue); ?>'); setTimeout(function() { scrollToSection('step_2'); }, 200);">
		<div style="background-image: url('<?php e_gpu(); ?>/<?php echo esc_html($widgetData['image']); ?>')"
			 class="aspect-square bg-cover rounded-lg relative group cursor-pointer transition shadow hover:shadow-lg"
		>
			<div x-show="chosenWidget == '<?php echo esc_html($widgetValue); ?>'">
				<div class="w-full inset-0 bg-black/30 absolute rounded-lg group-hover:opacity-0 transition"></div>
				<div class="w-full inset-0 opacity-0 transition absolute group-hover:opacity-100 bg-[radial-gradient(ellipse_at_top,_var(--tw-gradient-stops))] from-white via-transparent to-transparent"></div>
			</div>
			<div x-show="chosenWidget != '<?php echo esc_html($widgetValue); ?>'">
				<div class="w-full inset-0 opacity-100 transition absolute group-hover:opacity-100 bg-[radial-gradient(ellipse_at_top,_var(--tw-gradient-stops))] from-white via-transparent to-transparent"></div>
			</div>
			<h3 class="font-grotesk !text-black text-center w-full bg-amber-50/70 px-4 py-2 !text-sm !leading-tight absolute bottom-0 rounded-b-lg my-0 font-semibold"><?php echo esc_html($widgetData['title']); ?></h3>
		</div>
	</div>
<?php } ?>
