
function scrollToSection(idname, offset = 90) {
	const element = document.getElementById(idname);
	if (element) {
		// Get the top position of the element within the page
		const elementPosition = element.getBoundingClientRect().top + window.pageYOffset;

		// Scroll to the element, adjusted by the offset
		window.scrollTo({
			top: elementPosition - offset, // Subtract the offset
			behavior: 'smooth'
		});
	}
}

function fallbackCopyTextToClipboard(text) {
	var textArea = document.createElement("textarea");
	textArea.value = text;

	// Avoid scrolling to bottom
	textArea.style.top = "0";
	textArea.style.left = "0";
	textArea.style.position = "fixed";

	document.body.appendChild(textArea);
	textArea.focus();
	textArea.select();

	try {
		var successful = document.execCommand('copy');
		var msg = successful ? 'successful' : 'unsuccessful';
	} catch (err) { }

	document.body.removeChild(textArea);
}

function copyTextToClipboard(text) {
	if (!navigator.clipboard) {
		fallbackCopyTextToClipboard(text);
		return;
	}
	navigator.clipboard.writeText(text).then(function () {}, function (err) { });
}

document.addEventListener('alpine:init', () => {
	Alpine.data('mmac_alpine', () => ({
		stage: 1,
		chosenWidget: '',
		showMyBarError: false,

		cocktailChoiceName: '',
		cocktailChoiceId: '',

		ingredientChoiceName: '',
		ingredientChoiceId: '',

		width: '100',
		widthUnit: 'perc',
		backgroundChoice: 'transparent',
		darklightmode: 'light',
		borderRadius: 'md',
		background: '',
		showBorder: true,
		showImage: true,
		showMethod: true,
		showIngredients: true,
		showButton: true,

		uniqueString: '',
		key: '',

		showNotice: true,

		init() {
		this.showNotice = localStorage.getItem('mmac_shownotice') !== 'false';
		},

		chooseWidget(widgetChoice) {
			this.chosenWidget = widgetChoice;
			if(this.stage < 2) {
				this.stage = 2;
			}
		},

		stringToSlug(str) {
			str = str.replace(/^\s+|\s+$/g, ''); // trim
			str = str.toLowerCase();

			// remove accents, swap ñ for n, etc
			var from = "àáäâèéëêìíïîòóöôùúüûñç·/_,:;";
			var to = "aaaaeeeeiiiioooouuuunc------";
			for (var i = 0, l = from.length; i < l; i++) {
				str = str.replace(new RegExp(from.charAt(i), 'g'), to.charAt(i));
			}

			str = str.replace(/[^a-z0-9 -]/g, '') // remove invalid chars
				.replace(/\s+/g, '-') // collapse whitespace and replace by -
				.replace(/-+/g, '-'); // collapse dashes

			return str;
		},

		goToStage3() {
			if(this.key === '') {
				this.key = this.generateRandomKey(10);
			}
			this.uniqueString = this.generateUniqueString();

			// AJAX call to store the unique string
			fetch(admin_ajax_url, {
				method: 'POST',
				headers: {
					'Content-Type': 'application/x-www-form-urlencoded',
				},
				body: new URLSearchParams({
					action: 'store_unique_string',
					key: this.key,
					unique_string: this.uniqueString,
					nonce: nonce
				})
			}).then(response => response.json())
				.then(data => {
					if (data.success) {
						this.stage = 3;
						this.loadWidget();
					} else {
						console.error('Error storing unique string:', data.error);
					}
				})
				.catch(error => {
					console.error('Error:', error);
				});
		},

		generateRandomKey(length) {
			const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
			let result = '';
			for (let i = 0; i < length; i++) {
				result += characters.charAt(Math.floor(Math.random() * characters.length));
			}
			return result;
		},
		getShortcode() {
			return '[makemeacocktail id=\'' + this.key + '\']';
		},

		generateUniqueString() {
			const currentUrl = window.location.hostname; // Get the current URL's hostname
			let userChoices = {
				chosenWidget: this.chosenWidget,
				cocktailChoiceName: this.cocktailChoiceName,
				cocktailChoiceId: this.cocktailChoiceId,
				ingredientChoiceName: this.ingredientChoiceName,
				ingredientChoiceId: this.ingredientChoiceId,
				width: this.width,
				widthUnit: this.widthUnit,
				backgroundChoice: this.backgroundChoice,
				darklightmode: this.darklightmode,
				borderRadius: this.borderRadius,
				background: this.background,
				showBorder: this.showBorder,
				showImage: this.showImage,
				showMethod: this.showMethod,
				showIngredients: this.showIngredients,
				showButton: this.showButton,
				key: this.key,
				allowedReferers: [currentUrl],
			};
			let jsonString = JSON.stringify(userChoices);
			return btoa(jsonString, true);
		},

		loadWidget() {
			if(document.getElementById('mmac_widget_script_js')) {
				document.getElementById('mmac_widget_script_js').remove();
			}
			if (this.uniqueString) {
				let script = document.createElement('script');
				script.id = 'mmac_widget_script_js';
				script.src = 'https://makemeacocktail.com/js/wp-embed.js?code=' + this.uniqueString;

				document.getElementById('mmac_widget_script').appendChild(script);
			}
		},
	}));
});
