<?php
/**
 * Plugin Name: Make Me a Cocktail
 * Plugin URI: https://makemeacocktail.com/
 * Description: Cocktail recipe plugin
 * Version: 1.0.0
 * Author: Nick Wilkins
 * Author URI: https://nick-wilkins.com/
 **/


/**
 * Register our mmac_options_page to the admin_menu action hook.
 */
add_action( 'admin_menu', 'mmac_options_page' );
/**
 * Add the top level menu page.
 */
function mmac_options_page()
{
	add_menu_page(
		'Make Me a Cocktails',
		'Make Me a Cocktail',
		'manage_options',
		'mmac',
		'mmac_widget_creator_html'
	);

	add_submenu_page(
		'mmac',
		'Shortcode creator',
		'Shortcode creator',
		'manage_options',
		'mmac',
		'mmac_widget_creator_html'
	);
	add_submenu_page(
		'mmac',
		'About',
		'About',
		'manage_options',
		'mmac_about',
		'mmac_about_html'
	);

}


add_action('admin_enqueue_scripts', 'callback_for_setting_up_scripts');
function callback_for_setting_up_scripts() {
	wp_enqueue_style('base-css', gpu().'/css/master.css', '', '1.0.0');
}


/**
 * Top level menu callback function
 */
function mmac_about_html() {
	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}
	?>
	<div class="wrap">
	<h1 class="text-xl font-semibold">About Make Me a Cocktail</h1>

	<div class="p-4 shadow-md bg-white rounded-lg mt-6 text-gray-800 w-full mb-8">
		<a href="https://makemeacocktail.com" target="_blank"><img src="<?php e_gpu(); ?>img/logo.svg" class="w-14 h-14 block m-auto mb-4" alt="Cocktail icon"></a>
		<p class="text-sm">Make Me A Cocktail is the world’s best cocktail resource, with over 3000 amazing recipes, hundreds of user curated lists and a growing community of cocktail-making enthusiasts from around the world.</p>

		<p class="mt-4 text-sm">Our aim is to make it as easy as possible for you to find the perfect cocktail for any occasion. Whether you’re looking for a classic cocktail, a punch for a party or an original concoction, we have a cocktail for you.</p>

		<p class="mt-4 text-sm">We have a powerful MyBar utility where you can enter what ingredients you have and we'll show you what cocktails you can make. You can find out more on the <a href="https://makemeacocktail.com/mybar" class="underline">My Bar</a> page.</p>

		<a href="https://makemeacocktail.com" role="button" class="text-sm cursor-pointer px-6 rounded-lg text-center w-auto inline-block font-semibold py-2 hover:opacity-50 transition duration-150 font-semibold !text-white border border-0 mt-4 py-3" style="background: linear-gradient(180deg, #4984D6 0%, #286BCA 100%),
linear-gradient(180deg, #6D9CDE 0%, #4984D6 100%);">
        Find out more
    </a>
	</div>

	<?php include('incs/memberships.php'); ?>
	<?php
}
function mmac_widget_creator_html() {
	// check user capabilities
	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}
	?>

	<script>
	const admin_ajax_url = '<?php echo esc_js(admin_url('admin-ajax.php')); ?>';
	const nonce = '<?php echo esc_js(wp_create_nonce('store_unique_string_nonce')) ?>';
	</script>
	<script src="//unpkg.com/alpinejs" defer></script>
	<script src="<?php esc_js(e_gpu()); ?>js/mmac.js?t=<?php echo esc_js(time()); ?>"></script>

	<div class="wrap"  x-data="mmac_alpine()">
		<h1 class="text-xl font-semibold">Make Me a Cocktail</h1>

		<?php include('incs/notice.php'); ?>

		<?php include('incs/howto.php'); ?>

		<div class="text-center">
			<div class="py-10 flex flex-col gap-y-4">

				<!-- STEP 1 -->
				<div x-cloak>
					<?php include_once('incs/step-1.php'); ?>
				</div>

				<!-- STEP 2 -->
				<div x-show="stage > 1" x-transition  id="step_2" x-cloak>
					<?php include_once('incs/step-2.php'); ?>
				</div>

				<!-- STEP 3 -->
				<div x-show="stage > 2" x-transition id="step_3" x-cloak>
					<?php include_once('incs/step-3.php'); ?>
				</div>
			</div>
		</div>
	</div>
	<?php
}


add_action('wp_ajax_store_unique_string', 'store_unique_string');
add_action('wp_ajax_nopriv_store_unique_string', 'store_unique_string');
function store_unique_string() {
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'store_unique_string_nonce')) {
        wp_send_json_error(['error' => 'Nonce verification failed']);
    }

	if (!isset($_POST['key']) || !isset($_POST['unique_string'])) {
		wp_send_json_error(['error' => 'Invalid request']);
	}

	$key = sanitize_text_field($_POST['key']);
	$unique_string = sanitize_text_field($_POST['unique_string']);

	// Store the unique string in the options table with the key
	update_option('mmac_unique_string_' . $key, $unique_string);

	wp_send_json_success();
}

function gpu() {
	return plugin_dir_url(__FILE__);
}

function e_gpu() {
	echo esc_html(gpu());
}

// register shortocde of makemeacocktail
add_shortcode('makemeacocktail', 'makemeacocktail_shortcode');
function makemeacocktail_shortcode($atts) {

	$atts = shortcode_atts(
		array(
			'id' => '',
		),
		$atts
	);

	if(isset($atts['id'])) {
		$id = $atts['id'];
		if($id) {
			$unique_string = get_option('mmac_unique_string_' . $id);
			if($unique_string) {
				return '
					<div id="mmac_widget"></div>
					<script src="https://makemeacocktail.com/js/wp-embed.js?code=' . $id . '"></script>
				';
			} else {
				return 'Invalid ID';
			}
		} else {
			return 'Invalid ID';
		}
	}
}
